/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ch.randelshofer.media;

/**
 * A {@code Buffer} carries media data from one media processing unit to another.
 *
 * @author Werner Randelshofer
 * @version 1.0 2011-03-12 Created.
 */
public class Buffer {

    /** Indicates that the data in this buffer should be ignored. */
    public final static int FLAG_DISCARD = 1 << 1;
    
    /** Indicates that this Buffer holds a key frame. */
    public final static int FLAG_KEY_FRAME = 1 << 4;

    /** A flag mask that describes the boolean attributes for this buffer. */
    public int flags;

    /** The media data. */
    public Object data;

    /** The data offset. This field is only used if {@code data} is an array. */
    public int offset;

    /** The data length. This field is only used if {@code data} is an array. */
    public int length;

    /** Duration of a sample in the buffer in {@code timeScale} units.
     * The total duration of the buffer is {@code sampleCount * duration}.
     */
    public long duration;

    /** 
     * A time value that indicates the time scale for this media. That is,
     * the number of time units that pass per second in its time coordinate
     * system.
     */
    public long timeScale;

    /** The time stamp of this buffer in {@code timeScale} units. */
    public long timeStamp;

    /** The format of the data in this buffer. */
    public Format format;

    /** The number of samples in the data field. */
    public int sampleCount = 1;

    /** Returns true if the specified flag is set. */
    public boolean isSet(int flag) {
        return (flags & flag) == flag;
    }
    
    /** Sets all variables of this buffer to that buffer except for {@code data}.
     * This is like making a shallow clone of that buffer.
     */
    public void setTo(Buffer that) {
        //this.data=that.data;
        this.duration=that.duration;
        this.timeScale=that.timeScale;
        this.timeStamp=that.timeStamp;
        this.format=that.format;
        this.sampleCount=that.sampleCount;
        this.format=that.format;
        this.offset=that.offset;
        this.length=that.length;
    }
}
