/*
 * @(#)DefaultRegistry.java  1.0  2011-08-20
 * 
 * Copyright (c) 2011 Werner Randelshofer, Immensee, Switzerland.
 * All rights reserved.
 * 
 * You may not use, copy or modify this file, except in compliance with the
 * license agreement you entered into with Werner Randelshofer.
 * For details see accompanying license terms.
 */
package ch.randelshofer.media;

import java.nio.ByteOrder;
import java.util.HashMap;

/**
 * {@code DefaultRegistry}.
 *
 * @author Werner Randelshofer
 * @version 1.0 2011-08-20 Created.
 */
public class DefaultRegistry extends Registry {

    private HashMap<String, HashMap<String, HashMap<String, String>>> map;

    public DefaultRegistry() {
    }

    @Override
    protected void init() {
        map = new HashMap<String, HashMap<String, HashMap<String, String>>>();

        put(new FileFormat(FileFormat.AVI), new VideoFormat(VideoFormat.AVI_DIB), "ch.randelshofer.media.avi.DIBCodec");
        put(new FileFormat(FileFormat.AVI), new VideoFormat(VideoFormat.AVI_MJPG), "ch.randelshofer.media.jpeg.JPEGCodec");
        put(new FileFormat(FileFormat.AVI), new VideoFormat(VideoFormat.AVI_PNG), "ch.randelshofer.media.png.PNGCodec");
        put(new FileFormat(FileFormat.AVI), new VideoFormat(VideoFormat.AVI_RLE), "ch.randelshofer.media.avi.RunLengthCodec");
        put(new FileFormat(FileFormat.AVI), new VideoFormat(VideoFormat.AVI_TECHSMITH_SCREEN_CAPTURE), "ch.randelshofer.media.avi.TechSmithCodec");
        put(new FileFormat(FileFormat.AVI), new AudioFormat("\u0001\u0000\u0000\u0000", ByteOrder.BIG_ENDIAN), "ch.randelshofer.media.avi.AVIPCMAudioCodec");

        put(new FileFormat(FileFormat.QUICKTIME), new VideoFormat(VideoFormat.QUICKTIME_RAW, VideoFormat.QUICKTIME_RAW_COMPRESSOR_NAME), "ch.randelshofer.media.quicktime.RawCodec");
        put(new FileFormat(FileFormat.QUICKTIME), new VideoFormat(VideoFormat.QUICKTIME_ANIMATION, VideoFormat.QUICKTIME_ANIMATION_COMPRESSOR_NAME), "ch.randelshofer.media.quicktime.AnimationCodec");
        put(new FileFormat(FileFormat.QUICKTIME), new VideoFormat(VideoFormat.QUICKTIME_JPEG, VideoFormat.QUICKTIME_JPEG_COMPRESSOR_NAME), "ch.randelshofer.media.jpeg.JPEGCodec");
        put(new FileFormat(FileFormat.QUICKTIME), new VideoFormat(VideoFormat.QUICKTIME_PNG, VideoFormat.QUICKTIME_PNG_COMPRESSOR_NAME), "ch.randelshofer.media.png.PNGCodec");
        put(new FileFormat(FileFormat.QUICKTIME), new AudioFormat(AudioFormat.PCM_UNSIGNED, ByteOrder.BIG_ENDIAN), "ch.randelshofer.media.audio.PCMAudioCodec");
        put(new FileFormat(FileFormat.QUICKTIME), new AudioFormat(AudioFormat.PCM_SIGNED, ByteOrder.BIG_ENDIAN), "ch.randelshofer.media.audio.PCMAudioCodec");
        put(new FileFormat(FileFormat.QUICKTIME), new AudioFormat("twos", ByteOrder.BIG_ENDIAN), "ch.randelshofer.media.quicktime.QuickTimePCMAudioCodec");
        put(new FileFormat(FileFormat.QUICKTIME), new AudioFormat("sowt", ByteOrder.LITTLE_ENDIAN), "ch.randelshofer.media.quicktime.QuickTimePCMAudioCodec");
        put(new FileFormat(FileFormat.QUICKTIME), new AudioFormat("in24", ByteOrder.BIG_ENDIAN), "ch.randelshofer.media.quicktime.QuickTimePCMAudioCodec");
        put(new FileFormat(FileFormat.QUICKTIME), new AudioFormat("in32", ByteOrder.BIG_ENDIAN), "ch.randelshofer.media.quicktime.QuickTimePCMAudioCodec");
        put(new FileFormat(FileFormat.QUICKTIME), new AudioFormat("raw ", ByteOrder.BIG_ENDIAN/*, unsigned!! */), "ch.randelshofer.media.audio.quicktime.QuickTimePCMAudioCodec");

    }

    @Override
    public void put(FileFormat fileFormat, Format mediaFormat, String codecClass) {
        HashMap<String, HashMap<String, String>> fm = map.get(mediaFormat.getClass().getName());
        if (fm == null) {
            fm = new HashMap<String, HashMap<String, String>>();
            map.put(mediaFormat.getClass().getName(), fm);
        }

        HashMap<String, String> cm = fm.get(fileFormat.getEncoding());
        if (cm == null) {
            cm = new HashMap<String, String>();
            fm.put(fileFormat.getEncoding(), cm);
        }
        cm.put(mediaFormat.getEncoding(), codecClass);
    }

    @Override
    public String get(FileFormat fileFormat, Format mediaFormat) {
        HashMap<String, HashMap<String, String>> fm = map.get(mediaFormat.getClass().getName());
        if (fm == null) {
            return null;
        }
        HashMap<String, String> cm = fm.get(fileFormat.getEncoding());
        if (cm == null) {
            return null;
        }
        return cm.get(mediaFormat.getEncoding());
    }
}
