/*
 * @(#)FileFormat.java  1.0  2011-08-22
 * 
 * Copyright (c) 2011 Werner Randelshofer, Immensee, Switzerland.
 * All rights reserved.
 * 
 * You may not use, copy or modify this file, except in compliance with the
 * license agreement you entered into with Werner Randelshofer.
 * For details see accompanying license terms.
 */
package ch.randelshofer.media;

/**
 * {@code FileFormat}.
 *
 * @author Werner Randelshofer
 * @version 1.0 2011-08-22 Created.
 */
public class FileFormat implements Format {

    public final static String AVI="AVI";
    public final static String QUICKTIME="QuickTime";
    public final static String MP4="MP4";
    
    private String encoding;

    public FileFormat(String encoding) {
        this.encoding = encoding;
    }
    
    
    @Override
    public String getEncoding() {
       return encoding;
    }

    @Override
    public boolean matches(Format fmt) {
        if (fmt instanceof FileFormat) {
            FileFormat that=(FileFormat)fmt;
            return that.encoding.equals(this.encoding);
        }
        return false;
    }
    
}
