/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ch.randelshofer.media;

/**
 * {@code Format}.
 *
 * @author Werner Randelshofer
 * @version 1.0 2011-03-12 Created.
 */
public interface Format {
    /** Format values which are not specified must have this value. */
    public static final int NOT_SPECIFIED = -1;

    /** Returns the encoding name of the format. */
    public String getEncoding();
    
    /** Returns true if that format matches this format.
     * That is, iff the other format is an instance of this format, and all
     * specified values are identical.
     * 
     * @param that Another format.
     * @return True if the other format matches this format. 
     */
    public boolean matches(Format that);
}
