/*
 * @(#)MovieWriter.java  1.0  2011-03-12
 * 
 * Copyright (c) 2011 Werner Randelshofer, Immensee, Switzerland.
 * All rights reserved.
 * 
 * You may not use, copy or modify this file, except in compliance with the
 * license agreement you entered into with Werner Randelshofer.
 * For details see accompanying license terms.
 */
package ch.randelshofer.media;

import java.io.IOException;

/**
 * A simple API for writing movie data (audio and video) into a file.
 *
 * @author Werner Randelshofer
 * @version 1.0 2011-03-12 Created.
 */
public interface MovieWriter {

    /** Adds a track to the writer. 
     * 
     * @param format The format of the track.
     * @return The track number.
     */
    public int addTrack(Format format) throws IOException;

    /** Writes a sample into the specified track.
     * Does nothing if the discard-flag in the buffer is set to true.
     *
     * @param track The track number.
     * @param buf The buffer containing the sample data.
     */
    public void write(int track, Buffer buf) throws IOException;

    /** Closes the writer. */
    public void close() throws IOException;

    /** Returns true if the writer supports variable frame rates. */
    public boolean isVFRSupported();

    /** Returns true if the limit for media data has been reached.
     * If this limit is reached, no more samples should be added to the movie.
     * <p>
     * This limit is imposed by data structures of the movie file
     * which will overflow if more samples are added to the movie.
     */
    public boolean isDataLimitReached();
}
