/*
 * @(#)Registry.java  1.0  2011-08-20
 * 
 * Copyright (c) 2011 Werner Randelshofer, Immensee, Switzerland.
 * All rights reserved.
 * 
 * You may not use, copy or modify this file, except in compliance with the
 * license agreement you entered into with Werner Randelshofer.
 * For details see accompanying license terms.
 */
package ch.randelshofer.media;

/**
 * The {@code Registry} for audio and video codecs.
 *
 * @author Werner Randelshofer
 * @version 1.0 2011-08-20 Created.
 */
public abstract class Registry {
    private static Registry instance;

    
    public static Registry getInstance() {
        if (instance==null) {
            instance=new DefaultRegistry();
            instance.init();
        }
        return instance;
    }
    
    /** Initializes the registry. */
    protected abstract void init();

    /**
     * Puts a codec into the registry.
     * 
     * @param fileFormat The file format, e.g."AVI", "QuickTime".
     * @param mediaFormat The media format.
     * @param codecClass The codec class name.
     */
    public abstract void put(FileFormat fileFormat, Format mediaFormat, String codecClass);

    /**
     * Gets a codec from the registry.
     * 
     * @param fileFormat The file format, e.g."AVI", "QuickTime".
     * @param mediaFormat The media format.
     * @return The codec class name.
     */
    public abstract String get(FileFormat fileFormat, Format mediaFormat);
}
