/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ch.randelshofer.media;

/**
 * Defines a video format.
 *
 * @author Werner Randelshofer
 * @version 1.0 2011-03-12 Created.
 */
public class VideoFormat implements Format {

    /** The width of a video frame. */
    private final int width;
    /** The height of a video frame. */
    private final int height;
    /** The number of bits per pixel. */
    private final int depth;
    /** The data class. */
    private final Class dataClass;
    /** The encoding name. */
    private final String encoding;
    /** The compressor name. */
    private final String compressorName;
    /** 
     * A time value that indicates the time scale for this media. That is,
     * the number of time units that pass per second in its time coordinate
     * system.
     */
    private long timeScale;
    
    /** 
     * The frame rate in time scale units.
     */
    private long frameRate;
    // Standard video encoding strings
    public static final String IMAGE = "image";
    /** Cinepak format. */
    public static final String QUICKTIME_CINEPAK = "cvid";
    /** JPEG format. */
    public static final String QUICKTIME_JPEG = "jpeg";
    public static final String QUICKTIME_JPEG_COMPRESSOR_NAME = "Photo - JPEG";
    /** PNG format. */
    public static final String QUICKTIME_PNG = "png ";
    public static final String QUICKTIME_PNG_COMPRESSOR_NAME = "PNG";
    /** Animation format. */
    public static final String QUICKTIME_ANIMATION = "rle ";
    public static final String QUICKTIME_ANIMATION_COMPRESSOR_NAME = "Animation";
    /** Raw format. */
    public static final String QUICKTIME_RAW = "raw ";
    public static final String QUICKTIME_RAW_COMPRESSOR_NAME = "NONE";
    // AVI Formats
    /** Microsoft Device Independent Bitmap (DIB) format. */
    public static final String AVI_DIB = "DIB ";
    /** Microsoft Run Length format. */
    public static final String AVI_RLE = "RLE ";
    /** Techsmith Screen Capture format. */
    public static final String AVI_TECHSMITH_SCREEN_CAPTURE = "tscc";
    /** JPEG format. */
    public static final String AVI_MJPG = "MJPG";
    /** PNG format. */
    public static final String AVI_PNG = "png ";
    /** Interleaved planar bitmap format. */
    public static final String IFF_INTERLEAVED_BITMAP = "ILBM";

    public VideoFormat(String encoding) {
        this(encoding, null, NOT_SPECIFIED, NOT_SPECIFIED, NOT_SPECIFIED);
    }

    public VideoFormat(String encoding, Class dataClass, int width, int height, int depth) {
        this(encoding, encoding, dataClass, width, height, depth);
    }

    public VideoFormat(String encoding, String compressorName, Class dataClass, int width, int height, int depth) {
        this(encoding, encoding, dataClass, width, height, depth, NOT_SPECIFIED, NOT_SPECIFIED);
    }

    public VideoFormat(String encoding, Class dataClass, int width, int height, int depth, long timeScale, long frameRate) {
        this(encoding, encoding, dataClass, width, height, depth, timeScale, frameRate);
    }
    public VideoFormat(String encoding, String compressorName, Class dataClass, int width, int height, int depth, long timeScale, long frameRate) {
        this.encoding = encoding;
        this.compressorName = compressorName;
        this.dataClass = dataClass;
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.timeScale = timeScale;
        this.frameRate = frameRate;
    }

    public VideoFormat(String encoding, String compressorName) {
        this(encoding, compressorName, null, -1, -1, -1);
    }

    public int getDepth() {
        return depth;
    }

    public int getHeight() {
        return height;
    }

    public int getWidth() {
        return width;
    }

    public Class getDataClass() {
        return dataClass;
    }

    @Override
    public String getEncoding() {
        return encoding;
    }

    public String getCompressorName() {
        return compressorName;
    }

    public long getTimeScale() {
        return timeScale;
    }

    public long getFrameRate() {
        return frameRate;
    }

    @Override
    public String toString() {
        return "VideoFormat{"
                + "encoding=" + encoding + //
                //", compressorName=" + compressorName + //
                ", width=" + width + ", height=" + height + ", depth=" + depth + //
                ", dataClass=" + dataClass + //
                ", timeScale=" + timeScale + ", frameRate=" + frameRate + '}';
    }

    @Override
    public boolean matches(Format fmt) {
        if (fmt instanceof VideoFormat) {
            VideoFormat that = (VideoFormat) fmt;
            return (this.encoding==null||that.encoding==null||this.encoding.equals(that.encoding))
                    && (this.dataClass == null || that.dataClass == null || this.dataClass.equals(that.dataClass))
                    && (this.depth == NOT_SPECIFIED || that.depth == NOT_SPECIFIED || this.depth == that.depth)
                    && (this.frameRate == NOT_SPECIFIED || that.frameRate == NOT_SPECIFIED || this.frameRate == that.frameRate)
                    && (this.timeScale == NOT_SPECIFIED || that.timeScale == NOT_SPECIFIED || this.timeScale == that.timeScale)
                    && (this.width == NOT_SPECIFIED || that.width == NOT_SPECIFIED || this.width == that.width)
                    && (this.height == NOT_SPECIFIED || that.height == NOT_SPECIFIED || this.height == that.height);
        }
        return false;
    }
}
