/*
 * @(#)ANIMMultiplexer.java  1.0  2011-02-20
 * 
 * Copyright (c) 2011 Werner Randelshofer, Immensee, Switzerland.
 * All rights reserved.
 * 
 * You may not use, copy or modify this file, except in compliance with the
 * license agreement you entered into with Werner Randelshofer.
 * For details see accompanying license terms.
 */

package ch.randelshofer.media.anim;

import ch.randelshofer.media.Buffer;
import ch.randelshofer.media.Multiplexer;
import ch.randelshofer.media.image.BitmapImage;
import java.io.File;
import java.io.IOException;

/**
 * {@code ANIMMultiplexer}.
 *
 * @author Werner Randelshofer
 * @version 1.0 2011-02-20 Created.
 */
public class ANIMMultiplexer extends ANIMWriter implements Multiplexer {
 public ANIMMultiplexer(File file) throws IOException {
     super(file);
 }

    @Override
    public void write(int trackIndex, Buffer buf) throws IOException {
        if ((buf.flags&Buffer.FLAG_DISCARD)==0) {
            writeFrame((BitmapImage)buf.data,(int)(buf.duration*getJiffies()/buf.timeScale));
        }
    }

}
