/*
 * @(#)ANIMTrack.java  1.0  2011-02-20
 * 
 * Copyright (c) 2011 Werner Randelshofer, Immensee, Switzerland.
 * All rights reserved.
 * 
 * You may not use, copy or modify this file, except in compliance with the
 * license agreement you entered into with Werner Randelshofer.
 * For details see accompanying license terms.
 */

package ch.randelshofer.media.anim;

import ch.randelshofer.media.Buffer;
import ch.randelshofer.media.Track;
import ch.randelshofer.media.image.BitmapImage;

/**
 * {@code ANIMTrack}.
 *
 * @author Werner Randelshofer
 * @version 1.0 2011-02-20 Created.
 */
public class ANIMTrack implements Track {
    private ANIMDemultiplexer demux;
    private long position;

    public ANIMTrack(ANIMDemultiplexer demux) {
        this.demux=demux;
    }

    @Override
    public long getSampleCount() {
       return demux.getFrameCount();
    }

    @Override
    public void setPosition(long pos) {
       this.position=pos;
    }

    @Override
    public long getPosition() {
        return position;
    }

    @Override
    public void read(Buffer buf) {
        if (position < demux.getFrameCount()) {
            buf.flags=Buffer.FLAG_KEY_FRAME;
            if (!(buf.data instanceof BitmapImage)) {
                buf.data = demux.createCompatibleBitmap();
            }
            demux.readFrame((int)position,(BitmapImage) buf.data);
            buf.duration = demux.getDuration((int)position);
            buf.timeScale = demux.getJiffies();
            position++;
        } else {
            buf.flags =Buffer.FLAG_DISCARD;
        }
    }
}
